<?php

include_once 'conexao.php';
  
class ModeloResposta
{   
	static public function mdlAddResposta($dados){ 
  
		$stmt = Conexao::conectar()->prepare("INSERT INTO resposta 
						(resposta, idRecrutador, dataCadastro,pontuacao,idPergunta,idVaga,imagemResposta) VALUES (:resposta, :idRecrutador, :dataCadastro,:pontuacao,:idPergunta,:idVaga,:imagemResposta)");
		$stmt->bindParam(":pontuacao", $dados["pontuacao"], PDO::PARAM_STR);
		$stmt->bindParam(":resposta", $dados["resposta"], PDO::PARAM_STR);
		$stmt->bindParam(":dataCadastro", $dados["dataCadastro"], PDO::PARAM_STR);
		$stmt->bindParam(":idRecrutador", $dados["idUsuario"], PDO::PARAM_STR);
		$stmt->bindParam(":idPergunta", $dados["idPergunta"], PDO::PARAM_STR);
		$stmt->bindParam(":idVaga", $dados["idVaga"], PDO::PARAM_STR);
		$stmt->bindParam(":imagemResposta", $dados["imagemResposta"], PDO::PARAM_STR);
		if($stmt->execute()){
			return "ok";
		}else{
			return "error";
		}

	}  
 
	static public function mdlMostrarRespostaPorIdResposta($idResposta) {

	$resultado = array(); 

	$stmt = Conexao::conectar()->prepare("SELECT * FROM resposta where idResposta = :idResposta");
	$stmt->bindParam(":idResposta", $idResposta, PDO::PARAM_STR);
	$stmt ->execute();
	
	$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
	return $resultado;

	}

	static public function mdlVerificarRespostasPorIdPergunta($idPergunta,$resposta,$idVaga) {

		$resultado = array(); 

		$stmt = Conexao::conectar()->prepare("SELECT * FROM resposta where idPergunta = :idPergunta and resposta = :resposta and idVaga = :idVaga");
		$stmt->bindParam(":idPergunta", $idPergunta, PDO::PARAM_STR);
		$stmt->bindParam(":resposta", $resposta, PDO::PARAM_STR);
		$stmt->bindParam(":idVaga", $idVaga, PDO::PARAM_STR);
		$stmt ->execute();

		$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
		return $resultado;

	}

	static public function mdlMostrarTodasRespostasPorIdPergunta($idPergunta) {

		$resultado = array(); 

		$stmt = Conexao::conectar()->prepare("SELECT * FROM resposta where idPergunta = :idPergunta");
		$stmt->bindParam(":idPergunta", $idPergunta, PDO::PARAM_STR);
		$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}


	static public function mdlEditarRespostaPorIdResposta($idResposta, $pontuacao, $resposta){
 
		$stmt = Conexao::conectar()->prepare("UPDATE resposta SET pontuacao = :pontuacao, resposta = :resposta  where idResposta = :idResposta ");
		$stmt->bindParam(":idResposta", $idResposta, PDO::PARAM_STR);
		$stmt->bindParam(":pontuacao", $pontuacao, PDO::PARAM_STR);
		$stmt->bindParam(":resposta", $resposta, PDO::PARAM_STR);
		if($stmt->execute()){
			return "ok"; 
		}else{
			return "error";
		} 

	}

	static public function mdlEliminarRespostaPorIdResposta($id){
 
		$stmt = Conexao::conectar()->prepare("DELETE FROM resposta where idResposta = :id ");
		$stmt->bindParam(":id", $id, PDO::PARAM_STR);
		if($stmt->execute()){
			return "ok"; 
		}else{
			return "error";
		}

	}

	static public function mdlEliminarRespostasDeUmaPerguntaPorIdPergunta($idPergunta) {

		// Preparar a query para deletar as respostas com base no id da pergunta
		$stmt = Conexao::conectar()->prepare("DELETE FROM resposta WHERE idPergunta = :idPergunta");
	
		// Associar o parâmetro correto ($idPergunta) à query
		$stmt->bindParam(":idPergunta", $idPergunta, PDO::PARAM_STR);
	
		// Executar a query e verificar o resultado
		if ($stmt->execute()) {
			return "ok"; 
		} else {
			return "error";
		}
	}
	

}



?>